/*
 * Decompiled with CFR 0.152.
 */
import bird.util.Dbg;
import java.util.Vector;

public class WorkerThread
extends Thread {
    private Vector cmds_ = new Vector(10);
    private boolean mustStop_ = false;

    public WorkerThread(int n) {
        super("Worker-" + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Dbg.getInst().log("Started.", Dbg.LVL_SYS);
        while (!this.getMustStop()) {
            if (this.getNumCmds() == 0) {
                this.waitForCmd();
            }
            if (this.getMustStop()) break;
            WorkerCmd workerCmd = this.getNextCmd();
            if (workerCmd == null) continue;
            try {
                workerCmd.execute();
            }
            catch (Exception exception) {
            }
            finally {
                workerCmd.finished();
            }
            Thread.yield();
        }
        Dbg.getInst().log("Stopped gracefully.", Dbg.LVL_SYS);
    }

    public synchronized void setMustStop(boolean bl) {
        this.mustStop_ = bl;
        Thread.yield();
    }

    public synchronized void wakeup() {
        this.notifyAll();
        Thread.yield();
    }

    public synchronized void addCmd(WorkerCmd workerCmd) {
        this.cmds_.add(workerCmd);
        this.wakeup();
    }

    public synchronized void clearCmds() {
        try {
            this.cmds_.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized int getNumCmds() {
        return this.cmds_.size();
    }

    protected synchronized void waitForCmd() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected boolean getMustStop() {
        return this.mustStop_;
    }

    protected synchronized WorkerCmd getNextCmd() {
        WorkerCmd workerCmd = null;
        try {
            if (this.cmds_.size() > 0) {
                workerCmd = (WorkerCmd)this.cmds_.get(0);
                this.cmds_.remove(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return workerCmd;
    }
}

